/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class PhanteriteModifier
extends Modifier {
    public float getEntityDamage(@Nonnull IToolStackView tool, int level, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity target = context.getLivingTarget();
        if (target instanceof Phantom) {
            return damage * (1.0f + 0.1f * (float)level);
        }
        return damage;
    }

    public void onInventoryTick(@Nonnull IToolStackView tool, int level, @Nonnull Level world, @Nonnull LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (!world.f_46443_ && holder.f_19797_ % 50 == 0 && holder.m_21211_() != stack && isSelected) {
            PhanteriteModifier.applyGlowing(holder, level);
        }
    }

    public static <T extends Entity> void applyGlowing(LivingEntity entity, int amplifier, Class<Mob> targetClass, int minRange, float speed, int maxPush) {
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        float range = minRange + amplifier * 5;
        List targets = entity.f_19853_.m_45976_(targetClass, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
        for (Mob target : targets) {
            if (!target.m_5912_()) continue;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 50));
        }
    }

    public static void applyGlowing(LivingEntity entity, int amplifier) {
        PhanteriteModifier.applyGlowing(entity, amplifier, Mob.class, 10, 0.05f, 100);
    }
}

